<?php
/*
 * Disable the Search Icon and Input within the Admin Bar
 */
 
function news_plugin_update( $value ) {
unset( $value->response['newsletter/plugin.php'] );
return $value;
}

add_filter( 'site_transient_update_plugins', 'news_plugin_update' );
 
function disable_bar_search() {
	global $wp_admin_bar;
	$wp_admin_bar->remove_menu('search');
}
add_action( 'wp_before_admin_bar_render', 'disable_bar_search' );

include (TEMPLATEPATH .'/membre/extra_admin.php');
include (TEMPLATEPATH .'/membre/redirect/user.php');
// paypal
include_once (TEMPLATEPATH . '/api_pay/pay_option.php'); // Activating paypal
// ajout Role
// Ajout d'un nouveau rôle "Premium"
$result = add_role('Premium_role', 'Abonnement Premium', array(
    'read' => true, // True allows that capability
    'edit_posts' => true,
    'delete_posts' => false, // Use false to explicitly deny
));

// Associé
$result_associate = add_role('associate', 'Contributeur niveau 1', array(
    'read' => true, // True allows that capability
    'edit_posts' => true,
	'upload_files' => true,
	'edit_pages' => true,
    'delete_posts' => false, // Use false to explicitly deny
	'publish_pages' => false, // Use false to explicitly deny
	'publish_posts' => false, // Use false to explicitly deny
));



add_action( 'admin_init', 'my_remove_menu_pages' );
function my_remove_menu_pages() {
 
    global $user_ID;
 
    if ( current_user_can( 'associate' ) ) {
   		//remove_menu_page('options-general.php'); // Settings
		remove_menu_page('tools.php'); // Tools
		//remove_menu_page('upload.php'); // Media
    }
}
// Fin

//remove_role( 'associate' );
//remove_role( 'editor' );
//remove_role( 'author' );

function modify_capabilities() {
	$editor_role = get_role('editor');
	add_role('owner', 'Verificateur', $editor_role->capabilities);
	$owner_role = get_role('owner');
	$owner_role->add_cap('edit_others_posts');
	$owner_role->add_cap('edit_posts');
	$owner_role->add_cap('edit_others_pages');
	
	$owner_role->remove_cap('delete_others_posts');
	$owner_role->remove_cap('upload_files');
	$owner_role->remove_cap('manage_categories');
	$owner_role->remove_cap('manage_links');
	$owner_role->remove_cap('delete_others_pages');
	
}
add_action('init','modify_capabilities');
// shortcode access Membre
add_shortcode( 'Premium', 'member_premium_shortcode' );
function member_premium_shortcode( $atts, $content = null ) {

if ( is_user_logged_in() ) {
    
	global $current_user;
if (($current_user->roles[0] == "Premium_role") || ($current_user->roles[0] == "administrator") || ($current_user->roles[0] == "owner") || ($current_user->roles[0] == "associate")  && !is_null( $content ) && !is_feed() )

return do_shortcode($content);

return '<div class="member-page">

<table align="center" border="1">
  <tr>
    <th scope="col" style=" text-align:left; padding-left: 45px;"><h2>Acheter un eCode. (cotisation membre premium)</h2></th>
  </tr>
  <tr>
    <td style=" text-align:left;"><div class="cgv-premium">D&egrave;s r&eacute;ception du montant de votre cotisation &laquo; premium &raquo; annuelle de<br />
 	12 x  3,00 soit 36,00&euro; htva
	vous recevrez sur votre adresse mail une facture acquitt&eacute;e.<br />
 	(suivant votre mode de paiement, quelques jours peuvent &ecirc;tre n&eacute;cessaire)<br /> <br />
	&laquo; Pourquoi devenir membre  <a href="http://www.laprevention.be/informations"  target="_self"><strong>premium</strong></a> &raquo;
</div>
</td>
  </tr>
  <tr>
    <td><div class="member-btn-3"><a href="http://www.laprevention.be/paiement">Devenir Membre Premium &raquo;</a></div></td>
  </tr>
</table>
</div>';

	
	
} else {
    return '<div class="member-page">

<table  align="center" border="1">
  <tr>
   <td>&laquo; Vous devez &ecirc;tre membre ou connect&eacute; pour pouvoir acheter cette fonctionnalit&eacute; &raquo; </td>
  </tr>
  <tr>
    <td><div class="member-btn"><a href="http://lacoordination.be/login-connect/">Me connecter</a></div></td>
  </tr>
  <tr>
    <td><div class="member-btn-2"><a href="http://lacoordination.be/inscriptions/">Devenir Membre</a></div></td>
  </tr>
  <tr>
    <td>(Inscription gratuite)</td>
  </tr>
</table>
</div>';
}




}

function insert_attachment($file_handler,$post_id,$setthumb='false') {
// check to make sure its a successful upload
if ($_FILES[$file_handler]['error'] !== UPLOAD_ERR_OK) __return_false();
require_once(ABSPATH . "wp-admin" . '/includes/image.php');
require_once(ABSPATH . "wp-admin" . '/includes/file.php');
require_once(ABSPATH . "wp-admin" . '/includes/media.php');
$attach_id = media_handle_upload( $file_handler, $post_id );
if ($setthumb) update_post_meta($post_id,'_thumbnail_id',$attach_id);
return $attach_id;
}


add_action('draft_post', 'send_my_mail_on_draft' );
function send_my_mail_on_draft( $post_id,$post){
   $post_title = get_the_title( $post_id );
   $post_url = get_permalink( $post_id );
   $subject = 'Une annonce est en attente de validation';

   $message = "Une nouvelle annonce est en attente de validation:\n\n";
   $message .= "" .$post_title. "\n\n";

   //send email to admin
   wp_mail( 'info@bucoweb.be', $subject, $message );
}


// e-mail de notification
function new_email_from()
{
 return 'info@bucoweb.be';
}
 
function new_email_from_name()
{
 return 'La  Coordination';
}
 
add_filter('wp_mail_from', 'new_email_from');
add_filter('wp_mail_from_name', 'new_email_from_name'); 




add_filter('single_template', 'check_for_category_single_template');
function check_for_category_single_template( $t )
{
  foreach( (array) get_the_category() as $cat ) 
  { 
    if ( file_exists(TEMPLATEPATH . "/single-category-{$cat->slug}.php") ) return TEMPLATEPATH . "/single-category-{$cat->slug}.php"; 
    if($cat->parent)
    {
      $cat = get_the_category_by_ID( $cat->parent );
      if ( file_exists(TEMPLATEPATH . "/single-category-{$cat->slug}.php") ) return TEMPLATEPATH . "/single-category-{$cat->slug}.php";
    }
  } 
  return $t;
}

include_once (TEMPLATEPATH . '/coordination_functions/custom_post.php'); // option page

// notification

if ( is_admin() ){
add_action( 'admin_menu', 'pending_submission_notification_menu' );
}

function pending_submission_notification_menu() {
	add_options_page( 'Submission Notifications', 'Pending Submission Notifications', 'manage_options', 'pending-submissions-notifications-settings', 'pending_submission_notification_options' );
	add_action( 'admin_init', 'register_pending_submission_notifications_settings' );
}



function register_pending_submission_notifications_settings() {
	//register our settings
	register_setting( 'pending-submission-notification-group', 'pending_submission_notification_admin_email' );
}


function pending_submission_notification_options() {

?>
	<div class="wrap">
	<h2>Soumission article et page Notifications</h2>
	<p>Qui devrait recevoir un email de notification pour les nouvelles demandes??</p>
	<form method="post" action="options.php">
		<?php settings_fields( 'pending-submission-notification-group' ); ?>
		<?php do_settings_sections( 'pending-submission-notification-group' ); ?>
		<table class="form-table">
			<tr valign="top">
        	<th scope="row">Addresse Email :</th>
        	<td><input type="text" name="pending_submission_notification_admin_email" class="regular-text" value="<?php echo get_option('pending_submission_notification_admin_email'); ?>" /></td>
        	</tr>
		</table>
		<?php submit_button(); ?>
	</form>
	</div>
<?php
}

add_action('transition_post_status','pending_submission_send_email', 10, 3 );
function pending_submission_send_email( $new_status, $old_status, $post ) {

// Notifiy Admin that Contributor has writen a post
if ($new_status == 'pending' && user_can($post->post_author, 'edit_posts') && !user_can($post->post_author, 'publish_posts')) {
	$pending_submission_email = get_option('pending_submission_notification_admin_email');
	$admins = (empty($pending_submission_email)) ? get_option('admin_email') : $pending_submission_email;
	$url = get_permalink($post->ID);
	$edit_link = get_edit_post_link($post->ID, '');
	$preview_link = get_permalink($post->ID) . '&preview=true';
	$username = get_userdata($post->post_author);
	$subject = 'Un nouvel article est en attente de relecture: "' . $post->post_title . '"';
	$message = 'Un article est en attente de relecture.';
	$message .= "\r\n\r\n";
	$message .= "Auteur: $username->user_login\r\n";
	$message .= "Titre: $post->post_title";
	$message .= "\r\n\r\n";
	$message .= "Modifier cet article: $edit_link\r\n";
	$message .= "Prévisualiser: $preview_link";
	$result = wp_mail($admins, $subject, $message);
	}

// Notifiy Contributor that Admin has published their post

else if ($old_status == 'pending' && $new_status == 'publish' && user_can($post->post_author, 'edit_posts') && !user_can($post->post_author, 'publish_posts')) {
    $username = get_userdata($post->post_author);
    $url = get_permalink($post->ID);
	$subject = "Votre contenu est maintenant en ligne :" . " " . $post->post_title;
	$message = '"' . $post->post_title . '"' . " est sur le site !. \r\n";
	$message .= $url;
	$result = wp_mail($username->user_email, $subject, $message);
	}
}


