<?php
// create custom plugin settings menu
add_action('admin_menu', 'omr_create_menu');

function omr_create_menu() {

	//create new top-level menu
	add_menu_page('Paypal Options', 'Paypal Options', 10,basename(__FILE__), 'omr_settings_page');

	//call register settings function
	add_action( 'admin_init', 'register_mysettings' );
}

function register_mysettings() {
	//register our settings
	register_setting( 'omr-settings-group', 'paypal_id_code' );
	register_setting( 'omr-settings-group', 'prix_id_code' );
	register_setting( 'omr-settings-group', 'url_id_paiement' );
	register_setting( 'omr-settings-group', 'tva_code' );
	register_setting( 'omr-settings-group', 'desc_produit_code' );
	register_setting( 'omr-settings-group', 'desc_virement_code' );
	register_setting( 'omr-settings-group', 'url_free_code' );
	register_setting( 'omr-settings-group', 'url_cgv_code' );
	
	// annonces
	register_setting( 'omr-settings-group', 'press_category_free' );
	register_setting( 'omr-settings-group', 'url_id_code_press' );
	register_setting( 'omr-settings-group', 'html_id_code_press' );
	register_setting( 'omr-settings-group', 'url_free_press_fiche' );
}


function omr_settings_page() {
?>
<div class="wrap">

<h2>Paypal Options</h2>

<form method="post" action="options.php">

    <?php settings_fields('omr-settings-group'); ?>
    <table class="form-table">
    <th scope="row">Description service :</th>
        <td><input type="text" name="desc_produit_code" value="<?php echo get_option('desc_produit_code'); ?>" size="70"/></td>
        </tr>
    <tr valign="top">
        <th scope="row">Prix :</th>
        <td><input type="text" name="prix_id_code" value="<?php echo get_option('prix_id_code'); ?>" size="20"/> &euro;</td>
        </tr>
        <tr valign="top">
        <th scope="row"> Taux de TVA en vigueur</th>
        <td><input type="text" name="tva_code" value="<?php echo get_option('tva_code'); ?>" size="5"/>%<br />
        <small>Ajout de la tva ex : 21 <em>(sans le symbol %)</em></small>
		</td>
        
        </tr>
		<tr valign="top">
        <th scope="row">Id du paiement Fourni par paypal</th>
        <td><input type="text" name="paypal_id_code" value="<?php echo get_option('paypal_id_code'); ?>" size="70"/></td>
        </tr>    
        <!--<tr valign="top">
         <th scope="row">URL de Redirection ver la page de paiement</th>
        <td><input type="text" name="url_id_paiement" value="<?php // echo get_option('url_id_paiement'); ?>" size="70"/></td>
        </tr>-->
        

    </table>
    <table class="form-table">
 <h3 style="padding-bottom:5px; border-bottom: solid 1px #CCCCCC; width:650px; margin-top:30px;">Url de redirection pour les inscriptions gratuite</h3>
 <tr valign="top">
 <th scope="row">URL de Redirection ver la page :</th>
        <td><input type="text" name="url_free_code" value="<?php echo get_option('url_free_code'); ?>" size="70"/></td>
        </tr>
     </table>
      <table class="form-table">
   <h3 style="padding-bottom:5px; border-bottom: solid 1px #CCCCCC; width:650px; margin-top:30px;">Url de redirection pour les conditions générales</h3>
   <tr valign="top">
 <th scope="row">URL de Redirection ver la page :</th>
        <td><input type="text" name="url_cgv_code" value="<?php echo get_option('url_cgv_code'); ?>" size="70"/></td>
        </tr>     
		</table>
	 <table class="form-table">
 <h3 style="padding-bottom:5px; border-bottom: solid 1px #CCCCCC; width:650px; margin-top:30px;">Par versement bancaire</h3>
 <th scope="row">Description du paiement :</th>
        <td><textarea name="desc_virement_code" rows="5" cols="60"> <?php echo get_option('desc_virement_code'); ?></textarea></td>
        </tr>
		</table>
        
        </table>
<table class="form-table">
 <h3 style="padding-bottom:5px; border-bottom: solid 1px #CCCCCC; width:650px; margin-top:30px;">Options Page petites annonces</h3>
         <tr valign="top">
        <th scope="row">URL de Redirection ver la page après validation du formulaire</th>
        <td><input type="text" name="url_id_code_press" value="<?php echo get_option('url_id_code_press'); ?>" size="70"/></td>
        </tr>
       <!-- <tr valign="top">
        <th scope="row">URL de Redirection ver la page de Publication</th>
        <td><input type="text" name="url_free_press_fiche" value="<?php //echo get_option('url_free_press_fiche'); ?>" size="70"/></td>
        </tr>-->
        <!--<tr valign="top">
        <th scope="row">Code a ins&eacute;rer sur le site des utilsateurs</th>
        <td><textarea type="text" name="html_id_code_press" rows="5" cols="66"/><?php //echo get_option('html_id_code_press'); ?></textarea></td>
        </tr>-->
        <th scope="row">Identifiant des Categories disponible pour les annonces :</th>
        <td><input type="text" name="press_category_free" value="<?php echo get_option('press_category_free'); ?>" size="70"/></td>
        </tr>
        <tr valign="top">
        <th scope="row">Liste des Cat&eacute;gories :</th>
        <td>
        
		
		  <?php
$args=array(
  'orderby' => 'name',
  'order' => 'ASC',
  'hide_empty'=> 0
  );
$categories=get_categories($args);
  foreach($categories as $category) { 
    echo '<p><strong>' . $category->name.'</strong> Identifiant : <strong>'. $category->term_id . '</strong></p> ';
  } 
?>
		

        
        </td>
        </tr>
</table>
    <p class="submit">
    <input type="submit" class="button-primary" value="<?php _e('Save Changes') ?>" />
    </p>

</form>
</div>
<?php } ?>