<?php
/*
Plugin Name: User notify
Description: Change la fonction notifiacation de l'inscriptions
*/
 
// Redefine user notification function
if ( !function_exists('wp_new_user_notification') ) {

	function wp_new_user_notification( $user_id, $plaintext_pass = '' ) {

		$user = new WP_User( $user_id );

		$user_login = stripslashes( $user->user_login );
		$user_email = stripslashes( $user->user_email );

		$message  = sprintf( __('New user registration on %s:'), get_option('blogname') ) . "\r\n\r\n";
		$message .= sprintf( __('Username: %s'), $user_login ) . "\r\n\r\n";
		$message .= sprintf( __('E-mail: %s'), $user_email ) . "\r\n";
		$message .= sprintf( __('Text: %s'), '' ) . "\r\n";

		@wp_mail(
			get_option('admin_email'),
			sprintf(__('[%s] New User Registration'), get_option('blogname') ),
			$message
		);

		if ( empty( $plaintext_pass ) )
			return;

		$message  = __('Bonjour,') . "\r\n\r\n";
		$message .= sprintf( __("Bienvenue sur %s "), get_option('blogname')) . "\r\n\r\n";
		//$message .= 'http://lacoordination.be/login-connect/' . "\r\n";
		//$message .= sprintf( __('Username: %s'), $user_login ) . "\r\n";
		//$message .= sprintf( __('Password: %s'), $plaintext_pass ) . "\r\n\r\n";
		//$message .= sprintf( __("votre inscription est en cours de validation par l'administrateur %s."), get_option('blogname') ) . "\r\n\r\n";
		$message .= __("Votre inscription est en cours de validation par l'administrateur du portail de lacoordination.be.
Par sécurité un nouveau mot de passe vous sera envoyé, vous pourrez ensuite le modifier dans votre compte.
Merci de patienter avant de vous connecter");

		wp_mail(
			$user_email,
			sprintf( __('[%s] Your username and password'), get_option('blogname') ),
			$message
		);
	}
}
 
 
?>