<?php

@include_once 'commons.php';

$options = get_option('newsletter');

if ($action == 'save') {
    $options = stripslashes_deep($_POST['options']);
    update_option('newsletter', $options);
}

$nc = new NewsletterControls($options);
?>

<?php if ($options['novisual'] != 1) { ?>
<script type="text/javascript" src="<?php echo get_option('siteurl'); ?>/wp-content/plugins/newsletter/tiny_mce/tiny_mce.js"></script>

<script type="text/javascript">
    tinyMCE.init({
        mode : "specific_textareas",
        editor_selector : "visual",
        theme : "advanced",
        theme_advanced_disable : "styleselect",
        relative_urls : false,
        remove_script_host : false,
        theme_advanced_buttons3: "",
        theme_advanced_toolbar_location : "top",
        document_base_url : "<?php echo get_option('home'); ?>/"
    });
</script>
    <?php } ?>

<div class="wrap">

    <h2><?php _e('Abonnement Newsletter et d&eacute;sabonnement', 'newsletter'); ?></h2>

    <?php require_once 'header.php'; ?>

    <form method="post" action="">
        <?php wp_nonce_field(); ?>

        <h3><?php _e('Parametre expediteur et page d&acute;abonnement', 'newsletter'); ?></h3>
       
        <?php _e('<p style="color:#FF0000;"><strong>Cette parti doit &ecirc;tre obligatoirement remplit</strong></p>', 'newsletter'); ?>

        <table class="form-table">
            <tr valign="top">
                <th><?php _e('Votre Email :', 'newsletter'); ?></th>
                <td>
                    <?php $nc->text('from_email', 50); ?>
                    <br />
                    <?php _e('Inscrivez votre adresse e-mail elle sera visible pour vos abonn&eacute; a la r&eacute;ception des newsletters.', 'newsletter'); ?>
                </td>
            </tr>
            <tr valign="top">
                <th><?php _e('Nom de votre Newsletter'); ?></th>
                <td>
                    <?php $nc->text('from_name', 50); ?>
                    <br />
                    <?php _e('Inscrivez le nom de votre newsletter, le nom sera visible par vos abonn&eacute;s a la r&eacute;ception de l&acute;e-mail. (ex : votresite.com)', 'newsletter'); ?>
                </td>
            </tr>
            <tr valign="top">
                <th><?php _e('URL de la page d&acute;abonnement', 'newsletter'); ?></th>
                <td>
                    <?php $nc->text('url', 70); ?>
                    <br />
                    <?php _e('Ceci est le code que vous devez placer sur la page newsletter <strong>[newsletter]</strong>. (<a href="http://www.satollo.net/plugins/newsletter">Read more on plugin official page</a>)', 'newsleetter'); ?>
                </td>
            </tr>

            <tr valign="top">
                <th><?php _e('Th&egrave;me &agrave; utiliser pour les emails', 'newsletter'); ?></th>
                <td>
                    <select name="options[theme]">
                        <optgroup label="Included themes">
                            <option <?php echo ('blank'==$options['theme'])?'selected':''; ?> value="blank">Blank</option>
                            <option <?php echo ('messages'==$options['theme'])?'selected':''; ?> value="messages">For messages</option>
                        </optgroup>
                        <optgroup label="Extras themes">
                            <?php
                            $themes = newsletter_get_extras_themes();

                            foreach ($themes as $theme) {
                                echo '<option ' .  (('$'.$theme)==$options['theme']?'selected':'') . ' value="$' . $theme . '">' . $theme . '</option>';
                            }
                            ?>
                        </optgroup>
                        <optgroup label="Custom themes">
                            <?php
                            $themes = newsletter_get_themes();

                            foreach ($themes as $theme) {
                                echo '<option ' .  (('*'.$theme)==$options['theme']?'selected':'') . ' value="*' . $theme . '">' . $theme . '</option>';
                            }
                            ?>
                        </optgroup>
                    </select>
                    <br />
                    <?php _e('th&egrave;me des messages pr&eacute;d&eacute;fini ulisiser le code {message} pour le personaliser, et remplacer les messages ci-desous. Utilisez le th&egrave;me blank (<strong>recommand&eacute;</strong>) pour envoyer des messages comme vous les voyez dans l&acute;&eacute;diteur.', 'newsletter'); ?>
                </td>
            </tr>
        </table>
        <p class="submit">
            <?php $nc->button('save', __('Enregistrer', 'newsletter')); ?>
        </p>




        <h3><?php _e('Param&egrave;tre Abonnement', 'newsletter'); ?></h3>
        <table class="form-table">
            <tr valign="top">
                <th>&nbsp;</th>
                <td>
                    <?php $nc->checkbox('noname', __('Cochez cette case si vous voulez demander que l&acute;adresse e-mail sans le nom.', 'newsletter')); ?>
                </td>
            </tr>
            <tr valign="top">
                <th><?php _e('Page du formulaire d&acute;abonnement', 'newsletter'); ?></th>
                <td>
                    <?php $nc->editor('subscription_text'); ?>
                    <br />
                    <?php _e('Ce texte est celui montrer lors de l&acute;abonnement a votre newsletter(vous pouvez le modifier).', 'newsletter'); ?>
                </td>
            </tr>
            <tr valign="top">
                <th><?php _e('Message de confirmation de l&acute;abonnement', 'newsletter'); ?></th>
                <td>
                    <?php $nc->editor('subscribed_text'); ?>
                    <br />
                    <?php _e('Ceci est le texte montr&eacute; un utilisateur lorqu&acute;il clique sur "je m&acute;inscris" (vous pouvez le modifier).<br />
Tags: <strong>{name}</strong> sert a afiicher le nom de l&acute;utilisateur.; <strong>{email}</strong> sert a afiicher l&acute;e-mail de l&acute;utilisateur', 'newsletter'); ?>
                </td>
            </tr>
        </table>

        <p class="submit">
            <?php $nc->button('save', __('Enregistrer', 'newsletter')); ?>
        </p>



        <h3><?php _e('Confirmation (double opt-in)', 'newsletter'); ?></h3>

        <?php _e('<p>Courrier &eacute;lectronique envoy&eacute; a l&acute;utilisateur pour valider son inscription, la page de confirmation, message de bienvenue.</p>', 'newsletter'); ?>

        <table class="form-table">
            <tr valign="top">
                <th>&nbsp;</th>
                <td>
                    <?php $nc->checkbox('noconfirmation', __('Si cette case est coch&eacute;, les abonn&eacute;s seront imm&eacute;diatement confirm&eacute; et ils recevront un e-mail de bienvenue.', 'newsletter')); ?>
                </td>
            </tr>

            <!-- CONFIRMATION EMAIL -->
            <tr valign="top">
                <th><?php _e('Confirmation email', 'newsletter'); ?></th>
                <td>
                    <?php $nc->email('confirmation'); ?>
                    <br />
                    <?php _e('Tags: <strong>{name}</strong> sert a afiicher le nom de l&acute;utilisateur; <strong>{subscription_confirm_url}</strong>
Affiche URL de confirmation &agrave; &ecirc;tre cliqu&eacute; par l&acute;utilisateur de confirmer son inscription;
<strong>{unsubscription_url}</strong> affiche le lien pour d&eacute;sinscription ', 'newsletter'); ?>
                </td>
            </tr>

        </table>

        <p class="submit">
            <?php $nc->button('save', __('Enregistrer', 'newsletter')); ?>
        </p>



        <h3><?php _e('Message de bienvenue', 'newsletter'); ?></h3>
        <?php _e('<p>Utilisateurs passer cette &eacute;tape si vous avez d&eacute;sactiv&eacute; le double opt-in.</p>', 'newsletter'); ?>

        <table class="form-table">
            <tr valign="top">
                <th><?php _e('Message de bienvenue', 'newsletter'); ?></th>
                <td>
                    <?php $nc->editor('confirmed_text'); ?>
                    <br />
                    <?php _e('Message de confirmation lorsque l&acute;utilisateur a confirm&eacute; son inscription (vous pouvez le modifier).
<br />
Tags: <strong>{name}</strong> sert a afiicher le nom de l&acute;utilisateur; <strong>{email}</strong> sert a afiicher l&acute;e-mail de l&acute;utilisateur; <strong>{token}</strong> the subscriber unique token', 'newsletter'); ?>
                </td>
            </tr>

            <tr valign="top">
                <th><?php _e('Code de suivi de conversion', 'newsletter'); ?></th>
                <td>
                    <?php $nc->textarea('confirmed_tracking'); ?>
                    <br />
                    <?php _e('<strong>Fonctionne uniquement avec Newsletter Extras installer</strong>', 'newsletter'); ?>
                    <br />
                    <?php _e('Le code est inject&eacute; AS-IS en page d&acute;accueil et peut &ecirc;tre utilis&eacute; pour suivre la conversion
(vous pouvez utiliser PHP si n&eacute;cessaire). Code de conversion est habituellement d&acute;approvisionnement en services de suivi,
tels que Google AdWords, Google Analytics et ainsi de suite.', 'newsletter'); ?>
                </td>
            </tr>

            <!-- WELCOME/CONFIRMED EMAIL -->
            <tr valign="top">
                <th>
                    <?php _e('email de bienvenu<br /><small>Vous pouvez ajouter a cette des liens bonus(pub, partenaires.....) </small>', 'newsletter'); ?>
                </th>
                <td>
                    <?php $nc->email('confirmed'); ?>
                    <br />
                    <?php _e('Tags: <strong>{id}</strong> indentifiant utilisateur; <strong>{name}</strong>sert a afiicher le nom de l&acute;utilisateur; <strong>{unsubscription_url}</strong>
affiche le lien pour d&eacute;sinscription', 'newsletter'); ?>
                </td>
            </tr>

        </table>

        <p class="submit">
            <?php $nc->button('save', __('Enregistrer', 'newsletter')); ?>
        </p>



        <h3><?php _e('D&eacute;sinscription', 'newsletter'); ?></h3>
        <?php _e('<p>proc&eacute;dure de d&eacute;sabonnement en cliquant sur le lien de se d&eacute;sabonner dans
dans la newsletter. </p>', 'newsletter'); ?>

        <table class="form-table">
            <tr valign="top">
                <th><?php _e('Message de d&eacute;sabonnement', 'newsletter'); ?></th>
                <td>
                    <?php $nc->editor('unsubscription_text'); ?>
                    <br />
                    <?php _e('Ceci est le texte qui est montrer aux utilisateur lorqu&acute;ils ont clique sur le lien pour se d&eacute;sabonn&eacute;.
<br />
Tags: <strong>{name}</strong> sert a afiicher le nom de l&acute;utilisateur; <strong>{email}</strong> sert a afiicher l&acute;email de l&acute;utilisateur;
<strong>{unsubscription_confirm_url}</strong> URL pour confirmer d&eacute;sabonnement.', 'newsletter'); ?>
                </td>
            </tr>

            <!-- Text showed to the user on successful unsubscription -->
            <tr valign="top">
                <th><?php _e('Message d&acute;au revoir', 'newsletter'); ?></th>
                <td>
                    <?php $nc->editor('unsubscribed_text'); ?>
                </td>
            </tr>

            <!-- GOODBYE EMAIL -->
            <tr valign="top">
                <th><?php _e('email d&acute;au revoir ', 'newsletter'); ?></th>
                <td>
                    <?php $nc->email('unsubscribed'); ?>
                    <br />
                    <?php _e('Tags: <strong>{name}</strong>sert a afiicher le nom de l&acute;utilisateur.', 'newsletter'); ?>
                </td>
            </tr>
        </table>

        <p class="submit">
            <?php $nc->button('save', __('Enregistrer', 'newsletter')); ?>
        </p>



        <h3><?php _e('Advanced', 'newsletter'); ?></h3>

        <table class="form-table">
            <tr valign="top">
                <th><?php _e('D&eacute;sactiver &eacute;diteurs visuels?', 'newsletter')?></th>
                <td>
                    <?php $nc->yesno('novisual'); ?>
               </td>
            </tr>
        </table>
        <p class="submit">
            <?php $nc->button('save', __('Enregistrer', 'newsletter')); ?>
        </p>

    </form>
</div>
