<?php
/** "Video_player_media" block 
 * 
 * 
 * Video Player
**/


// Define class
class AQ_Video_Player_Media_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Lecteur Video youtube, vimeo',
			'size' => 'span12',
			
		);
		
		//create the block
		parent::__construct('aq_video_player_media_block', $block_options);
	}
	
	function form($instance) {
		
		$theme_options = array(
			'light' => 'Light',
			'dark' => 'Dark',
		);
		
		$player_options = array(
			'youtube' => 'Youtube',
			'vimeo' => 'Vimeo',
		);
		
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		$line_color = isset($line_color) ? $line_color : '#353535';
		
		?>
		<p class="description note">
			<?php _e('Utiliser ce bloc  pour afficher une vidéo Youtube / Vimeo', 'wpthematic') ?>
		</p>
     
         <p class="description">
       <label for="<?php echo $this->get_field_id('title') ?>">
				 Titre
				<?php echo aq_field_input('title', $block_id, $title, $size = 'full') ?>
			</label>
            </p>
        <p class="description">
			<label for="<?php echo $this->get_field_id('video_player_select') ?>">
				Sélectionner le lecteur vidéo.<br/>
				<?php echo aq_field_select('video_player_select', $block_id, $player_options, $video_player_select, $block_id); ?>
			</label>
		</p>    
            <p class="description">
       <label for="<?php echo $this->get_field_id('video_id') ?>">
				 Id de la vidéo
				<?php echo aq_field_input('video_id', $block_id, $video_id, $size = 'small') ?>
			</label>
            </p>
             <p class="description">
       <label for="<?php echo $this->get_field_id('video_start') ?>">
				 Départ de la vidéo
				<?php echo aq_field_input('video_start', $block_id, $video_start, $size = 'min') ?> Seconde <em>(Youtube)</em>
			</label>
            </p>
            <p class="description">
             <label for="<?php echo $this->get_field_id('autoplay') ?>">
            
            <?php echo aq_field_checkbox('autoplay', $block_id, $autoplay, $check);?>
            Lecture automatique ?
            </label>
             </p>
             <p class="description">
			<label for="<?php echo $this->get_field_id('player_theme') ?>">
				Choisissez le thème du lecteur <em>(Youtube)</em>.<br/>
				<?php echo aq_field_select('player_theme', $block_id, $theme_options, $player_theme, $block_id); ?>
			</label>
		</p>       
                    
<p class="description note">
<label for="<?php echo $this->get_field_id('bg_video_color') ?>">
				Couleur de fond si il ni a pas d'image
				<?php echo aq_field_color_picker('bg_video_color', $block_id, $bg_video_color, $defaults['bg_video_color']) ?>
			</label>
            <p class="description note">
         <label for="<?php echo $this->get_field_id('text_video') ?>">
				Description
				<?php echo aq_field_textarea('text_video', $block_id, $text_video, $size = 'full') ?>
			</label>
		</p>
		<?php
		
	}
	

	function block($instance) {
		extract($instance);
		
		switch($video_player_select) {
			case 'youtube':
				
		
		$output .= '<h2 class="title-video"><span>'.$title.'</span></h2>';
		$output .= '<div class="video-contrainer-media"><object>
  <param name="movie" value="https://www.youtube.com/v/'.$video_id.'?autoplay='.$autoplay.'&start='.$video_start.'&cc_load_policy=1&color=white&theme='.$player_theme.'&version=3"></param>
  <param name="allowFullScreen" value="true"></param>
  <param name="allowScriptAccess" value="always"></param>
  <embed src="https://www.youtube.com/v/'.$video_id.'?autoplay='.$autoplay.'&start='.$video_start.'&cc_load_policy=1&color=white&theme='.$player_theme.'&version=3" type="application/x-shockwave-flash" allowfullscreen="true" allowScriptAccess="always"></embed>
</object></div>';
		$output .=''.$text_video.'';
	  
	
	echo $output;
	break;
	
	case 'vimeo':
				$output .= '<h2><span>'.$title.'</span></h2>';
				$output .='<div class="video-contrainer-media"><object>
    <param name="allowfullscreen" value="true" />
    <param name="allowscriptaccess" value="always" />
    <param name="movie" value="http://vimeo.com/moogaloop.swf?clip_id='.$video_id.'&amp;autoplay='.$autoplay.'&amp;server=vimeo.com&amp;color=00adef&amp;fullscreen=1" />
    <embed src="http://vimeo.com/moogaloop.swf?clip_id='.$video_id.'&amp;autoplay='.$autoplay.'&amp;server=vimeo.com&amp;color=00adef&amp;fullscreen=1"
        type="application/x-shockwave-flash" allowfullscreen="true" allowscriptaccess="always"></embed>
</object></div>';
				$output .=''.$text_video.'';
	  
	
	echo $output;
				break;
		}
		
	}
	
}


