<?php
/** A simple text block **/
class AQ_Ticker_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'News ticker',
			'size' => 'span12',
		);
		
		//create the block
		parent::__construct('aq_ticker_block', $block_options);
	}
	
	function form($instance) {
		
		$defaults = array(
			'text' => '',
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		$block_color = isset($block_color) ? $block_color : '#FFFFFF';
		$txt_block_color = isset($txt_block_color) ? $txt_block_color : '#000000';
		?>
		<p class="description">
			<label for="<?php echo $this->get_field_id('title') ?>">
				Titre 
				<?php echo aq_field_input('title', $block_id, $title, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('title_block_color') ?>">
				Couleur de fond du news Ticker
				<?php echo aq_field_color_picker('block_color', $block_id, $block_color, $defaults['block_color']) ?>
			</label>
            <label for="<?php echo $this->get_field_id('title_block_color') ?>">
				Couleur du texte
				<?php echo aq_field_color_picker('txt_block_color', $block_id, $txt_block_color, $defaults['txt_block_color']) ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('size_block_txt') ?>">
				<div style="width:230px; float:left;">taille du texte en px (exemple 14px)</div> 
				<?php echo aq_field_input('size_block_txt', $block_id, $size_block_txt, $size = 'min') ?>
			</label>
            <br/>
            <label for="<?php echo $this->get_field_id('height_block_txt') ?>">
				<div style=" width:230px; float:left;">Hauteur du news Ticker en px</div> 
				<?php echo aq_field_input('height_block_txt', $block_id, $height_block_txt, $size = 'min') ?>
			</label>
            
		</p>
		
        
		<p class="description">
			<label for="<?php echo $this->get_field_id('text') ?>">
				Contenu 1
				<?php echo aq_field_textarea('text', $block_id, $text, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('lien1') ?>">
				Lien 1
				<?php echo aq_field_input('lien1', $block_id, $lien1, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('text2') ?>">
				Contenu 2
				<?php echo aq_field_textarea('text2', $block_id, $text2, $size = 'full') ?>
			</label>
            <label for="<?php echo $this->get_field_id('lien2') ?>">
				Lien 2
				<?php echo aq_field_input('lien2', $block_id, $lien2, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('text3') ?>">
				Contenu 3
				<?php echo aq_field_textarea('text3', $block_id, $text3, $size = 'full') ?>
			</label>
            <label for="<?php echo $this->get_field_id('lien3') ?>">
				Lien 3
				<?php echo aq_field_input('lien3', $block_id, $lien3, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('text4') ?>">
				Contenu 4
				<?php echo aq_field_textarea('text4', $block_id, $text4, $size = 'full') ?>
			</label>
           <label for="<?php echo $this->get_field_id('lien4') ?>">
				Lien 4
				<?php echo aq_field_input('lien4', $block_id, $lien4, $size = 'full') ?>
			</label>
        
           
       
		</p>
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
		echo '<div class="row section_featured_texts">';
		echo '<div class="column one-third" id="section_featured_texts" style="background:'.$block_color.'; color: '.$txt_block_color.';">';
		echo '<ul id="ticker01">';
		
		if(!empty($text)){
		echo'<li><a href="'.$lien1.'">'.$text.'</a></li>';	
		}
		else
		{
		
		}
		
		// 02
		
		if(!empty($text2)){
			
		echo'<li><a href="'.$lien2.'">'.$text2.'</a></li>';	
		}
		else
		{
		
		}
		
		if(!empty($text3)){
		echo'<li><a href="'.$lien3.'">'.$text3.'</a></li>';
		}
		else
		{
		
		}
		
		if(!empty($text4)){
		echo'<li><a href="'.$lien4.'">'.$text4.'</a></li>';
		}
		else
		{
		
		}
		
		echo'</ul>';
		
		echo'</div>';
		echo'</div>';
		
		?> 
        <style>
		ul.newsticker a {

			color: <?php echo $txt_block_color;?>;
			font-size:<?php echo $size_block_txt;?>;

			} 
			
			.tickercontainer {
				background: <?php echo $block_color;?>;
				height: <?php echo $height_block_txt;?>; 
			
			}
		</style>
		 <script>
	$(function(){
	$("ul#ticker01").liScroll({travelocity: 0.05});
	});
	</script>
		<?php
	}
}