<?php
/** A simple text block **/
class AQ_Team_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Team Bloc',
			'size' => 'span3',
			'resizable' => 1,
		);
		
		//create the block
		parent::__construct('aq_team_block', $block_options);
	}
	
	function form($instance) {
		
		$defaults = array(
			'text' => '',
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		$block_color = isset($block_color) ? $block_color : '#FFFFFF';
		$txt_block_color = isset($txt_block_color) ? $txt_block_color : '#000000';
		?>
		<p class="description">
			<label for="<?php echo $this->get_field_id('title') ?>">
				Non et Prénom 
				<?php echo aq_field_input('title', $block_id, $title, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('p_fonc') ?>">
				Poste/Fonction
				<?php echo aq_field_input('p_fonc', $block_id, $p_fonc, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('title_color') ?>">
				Couleur du texte Non et Prénom
				<?php echo aq_field_color_picker('title_color', $block_id, $title_color, $defaults['title_color']) ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('title_block_color') ?>">
				Couleur de fond du bloc
				<?php echo aq_field_color_picker('block_color', $block_id, $block_color, $defaults['block_color']) ?>
			</label>
            <label for="<?php echo $this->get_field_id('title_block_color') ?>">
				Couleur du texte
				<?php echo aq_field_color_picker('txt_block_color', $block_id, $txt_block_color, $defaults['txt_block_color']) ?>
			</label>
            
		</p>
		<p>
		<?php echo aq_field_upload('txt_icon', $block_id, $txt_icon, $media_type = 'image');?>
        <img class="upload_images_txt" src="<?php echo $txt_icon ; ?>" border="0"/>
        
        </p>
        
		<p class="description">
			<label for="<?php echo $this->get_field_id('text') ?>">
				Biographie
				<?php echo aq_field_textarea('text', $block_id, $text, $size = 'full') ?>
			</label>
           
           <label for="<?php echo $this->get_field_id('fb_team_link') ?>">
				 Facebook
				<?php echo aq_field_input('fb_team_link', $block_id, $fb_team_link, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('tw_team_link') ?>">
				 Twitter
				<?php echo aq_field_input('tw_team_link', $block_id, $tw_team_link, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('gp_team_link') ?>">
				 Google +
				<?php echo aq_field_input('gp_team_link', $block_id, $gp_team_link, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('pin_team_link') ?>">
				 Pinterest
				<?php echo aq_field_input('pin_team_link', $block_id, $pin_team_link, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('link_team_link') ?>">
				 Linkedin
				<?php echo aq_field_input('link_team_link', $block_id, $link_team_link, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('viadeo_team_link') ?>">
				 Viadeo
				<?php echo aq_field_input('viadeo_team_link', $block_id, $viadeo_team_link, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('it_team_link') ?>">
				 Scoopt it
				<?php echo aq_field_input('it_team_link', $block_id, $it_team_link, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('rss_team_link') ?>">
				RSS
				<?php echo aq_field_input('rss_team_link', $block_id, $rss_team_link, $size = 'full') ?>
			</label>
			
            <label for="<?php echo $this->get_field_id('custom_link_name') ?>">
				Site Web Nom
				<?php echo aq_field_input('custom_link_name', $block_id, $custom_link_name, $size = 'full') ?>
			</label>        
        
           <label for="<?php echo $this->get_field_id('custom_link') ?>">
				Site Web lien
				<?php echo aq_field_input('custom_link', $block_id, $custom_link, $size = 'full') ?>
			</label>
            
		</p>
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
		// checkbox value
		if( $target_link ) {
			echo'';
		
		} else {
			echo '';
			};
		echo '<div class="team-columms" style="'.$team_align.' background:'.$block_color.'; color: '.$txt_block_color.';">';
		echo '<div class="four columns">';
		echo '<div class="pic"><img src="'.$txt_icon.'" border="0"/>';
		if($title) echo '<h4 style="color: '.$title_color.';">'.strip_tags($title).'</h4>';
		if($p_fonc) echo '<p class="function_team"><strong>'.strip_tags($p_fonc).'</strong></p>';
		
		echo '<p style="color: '.$txt_block_color.';" class="team_desc">'.$text.'</p>';
		
		if( $custom_link ) {
		  	echo 'Site Web : <a href="'.$custom_link.'" target="_blank" title="'.$custom_link_name.'">'.$custom_link_name.'</a>';
		} else {};
		
		echo '<div class="footer_social_inner">';
		
		if( $fb_team_link ) {
	      	echo'<a href="'.$fb_team_link.'" target="_blank" class="icon_facebook_team" title="Facebook">Facebook</a>';
	    } else {};
		
		if( $pin_team_link ) {
		  	echo '<a href="'.$pin_team_link.'" target="_blank" class="icon_pinterest_team" title="Pinterest">Pinterest</a>';
		} else {};
		
		if( $tw_team_link ) {
	      	echo '<a href="'.$tw_team_link.'" target="_blank" class="icon_tweet_team" title="Tweeter">Tweeter</a>';
		} else {};
		
		if( $link_team_link ) {
			echo '<a href="'.$link_team_link.'" class="icon_linkedin_team" title="Linkedin">Linkedin</a>';
		} else {};
		
		if( $gp_team_link ) {
		  	echo '<a href="'.$gp_team_link.'" target="_blank" class="icon_google_team" title="Google+">Google+</a>';
		} else {};
		
		if( $viadeo_team_link ) {
		  	echo '<a href="'.$viadeo_team_link.'" target="_blank" class="icon_viadeo_team" title="Viadeo">Viadeo</a>';
		} else {};
		
		if( $it_team_link ) {
		  	echo '<a href="'.$it_team_link.'" target="_blank" class="icon_it_team" title="Scoop It">Scoop It</a>';
		} else {};
		
		if( $rss_team_link ) {
		  	echo '<a href="'.$rss_team_link.'" target="_blank" class="icon_rss_team" title="RSS">RSS</a>';
		} else {};
		
		
		echo'</div>';
        	
		echo'</div>';
		echo '</div>';	
		echo '</div>';
	}
	
	
}