<?php
/* Aqua Tabs Block */
if(!class_exists('AQ_Tabs_Block')) {
	class AQ_Tabs_Block extends AQ_Block {
	
		function __construct() {
			$block_options = array(
				'name' => 'Tabs &amp; Toggles',
				'size' => 'span6',
			);
			
			//create the widget
			parent::__construct('AQ_Tabs_Block', $block_options);
			
			//add ajax functions
			add_action('wp_ajax_aq_block_tab_add_new', array($this, 'add_tab'));
			
		}
		
		function form($instance) {
		
			$defaults = array(
				'tabs' => array(
					1 => array(
						'title' => 'Nouvel &eacute;l&eacute;ment',
						'content' => 'Contenu',
					)
				),
				'type'	=> 'tab',
			);
			
			$instance = wp_parse_args($instance, $defaults);
			extract($instance);
			
			$tab_types = array(
				'tab' => 'Tabs',
				'toggle' => 'Toggles',
				'accordion' => 'Accordion'
			);
			
			?>
			<div class="description cf">
            <p class="description">
            <label for="<?php echo $this->get_field_id('tab_title') ?>">
				 Titre
				<?php echo aq_field_input('tab_title', $block_id, $tab_title, $size = 'full') ?>
			</label>
            </p>
				<ul id="aq-sortable-list-<?php echo $block_id ?>" class="aq-sortable-list" rel="<?php echo $block_id ?>">
					<?php
					$tabs = is_array($tabs) ? $tabs : $defaults['tabs'];
					$count = 1;
					foreach($tabs as $tab) {	
						$this->tab($tab, $count);
						$count++;
					}
					?>
				</ul>
				<p></p>
				<a href="#" rel="tab" class="aq-sortable-add-new button">Ajouter</a>
				<p></p>
			</div>
            
            <label for="<?php echo $this->get_field_id('block_element_color') ?>">
				Couleur de l'élément
				<?php echo aq_field_color_picker('block_element_color', $block_id, $block_element_color, $defaults['block_element_color']) ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('text_element_color') ?>">
				Couleur du texte de l'élément
				<?php echo aq_field_color_picker('text_element_color', $block_id, $text_element_color, $defaults['text_element_color']) ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('block_element_color_active') ?>">
				Couleur de l'élément actif
				<?php echo aq_field_color_picker('block_element_color_active', $block_id, $block_element_color_active, $defaults['block_element_color_active']) ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('text_element_color_active') ?>">
				Couleur du texte de l'élément actif
				<?php echo aq_field_color_picker('text_element_color_active', $block_id, $text_element_color_active, $defaults['text_element_color_active']) ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('tab_id') ?>">
				 Identifiant
				<?php echo aq_field_input('tab_id', $block_id, $tab_id, $size = 'full') ?>
			</label>
			<p class="description">
				<label for="<?php echo $this->get_field_id('type') ?>">
					Style<br/>
					<?php echo aq_field_select('type', $block_id, $tab_types, $type) ?>
				</label>
			</p>
			<?php
		}
		
		function tab($tab = array(), $count = 0) {
				
			?>
            
			<li id="<?php echo $this->get_field_id('tabs') ?>-sortable-item-<?php echo $count ?>" class="sortable-item" rel="<?php echo $count ?>">
				
				<div class="sortable-head cf">
					<div class="sortable-title">
						<strong><?php echo $tab['title'] ?></strong>
					</div>
					<div class="sortable-handle">
						<a href="#">Ouvrir / Fermer</a>
					</div>
				</div>
				
				<div class="sortable-body">
                
					<p class="tab-desc description">
						<label for="<?php echo $this->get_field_id('tabs') ?>-<?php echo $count ?>-title">
							Titre<br/>
							<input type="text" id="<?php echo $this->get_field_id('tabs') ?>-<?php echo $count ?>-title" class="input-full" name="<?php echo $this->get_field_name('tabs') ?>[<?php echo $count ?>][title]" value="<?php echo $tab['title'] ?>" />
						</label>
					</p>
					<p class="tab-desc description">
						<label for="<?php echo $this->get_field_id('tabs') ?>-<?php echo $count ?>-content">
							Contenu<br/>
							<textarea id="<?php echo $this->get_field_id('tabs') ?>-<?php echo $count ?>-content" class="textarea-full" name="<?php echo $this->get_field_name('tabs') ?>[<?php echo $count ?>][content]" rows="5"><?php echo $tab['content'] ?></textarea>
						</label>
					</p>
					<p class="tab-desc description"><a href="#" class="sortable-delete">Supprimer</a></p>
				</div>
				
			</li>
			<?php
		}
		
		function block($instance) {
			extract($instance);
			
			//wp_enqueue_script('jquery-ui-tabs');
			
			
			
			if($type == 'tab') {
				
				$output = '<style>
			.htabs a {
	color: '.$text_element_color.';
	background: '.$block_element_color.';
	
}
			.htabs a.selected {
	background: '.$block_element_color_active.';
	color : '.$text_element_color_active.';
}
.tab-content {
	color : '.$text_element_color_active.';
	background: '.$block_element_color_active.';
}


			</style>';
				
				$output .= '<h2 class="title"><span>'.$tab_title.'</span></h2>';
				
				$output .= '<div id="tabs_'. rand(1, 100) .'" class="htabs"><div class="'.$tab_id.'">';
					//$output .= '<ul class="aq-nav cf">';
					
					$i = 1;
					foreach( $tabs as $tab ){
						$tab_selected = $i == 1 ? 'selected' : '';
						$output .= '<a href="#tab-'. sanitize_title( $tab['title'] ) . $i .'" class="'.$tab_selected.'">' . $tab['title'] . '</a>';
						$i++;
					}
					
					$output .= '</div>';
					$output .='</div>';
					$i = 1;
					foreach($tabs as $tab) {
						
						$output .= '<div id="tab-'. sanitize_title( $tab['title'] ) . $i .'" class="tab-content">'. wpautop(do_shortcode(htmlspecialchars_decode($tab['content']))) .'</div>';
						
						$i++;
					}
				
				$output .= "<script type='text/javascript'>
					$('.".$tab_id." a').tabs();
				</script>";
				
			} elseif ($type == 'toggle') {
				
					$output = '<style>
	.toggle_item {
	color: '.$text_element_color.';
	background: '.$block_element_color.';
	
}
	.toggle_item:hover {
	background: '.$block_element_color_active.';
	color : '.$text_element_color_active.';
}


			</style>';
				
				$output .= '<h2 class="title"><span>'.$tab_title.'</span></h2>';
				
				$output .= '<div class="toggle_holder_'.rand(1,100).'">';
				
				foreach( $tabs as $tab ){
					$output  .= '<div class="toggle_item">';
						$output .= '<h4 class="toggle-faq_'.$tab_id.' title_el"><span class="toggle_control"></span><span class="toggle_heading">'. $tab['title'] .'</span></h4>';
						//$output .= '<div class="arrow"></div>';
						$output .= '<div class="toggle-faq_content">';
							$output .= wpautop(do_shortcode(htmlspecialchars_decode($tab['content'])));
						$output .= '</div>';
					$output .= '</div>';
				}
				
				$output .= '</div>';
				
				$output .= '<script type="text/javascript">
    $(".toggle-faq_content").hide();
    $(".toggle-faq_'.$tab_id.'").click(function () {
        $(this).next(".toggle-faq_content").slideToggle(500);
        $(this).toggleClass("toggle_acc");
    });
</script>';
				
			} elseif ($type == 'accordion') {
				
				$count = count($tabs);
				$i = 1;
				
				$output = '<style>
			.acc_item {
	color: '.$text_element_color.';
	background: '.$block_element_color.';
	
}
			.acc_item:hover  {
	background: '.$block_element_color_active.';
	color : '.$text_element_color_active.';
}



			</style>';
				
				$output .= '<h2 class="title"><span>'.$tab_title.'</span></h2>';
				
				$output .= '<div class="acc_holder_'.rand(1,100).'">';
				
				foreach( $tabs as $tab ){
					
					$open = $i == 1 ? 'open' : 'close';
					
					$child = '';
					if($i == 1) $child = 'first-child';
					if($i == $count) $child = 'last-child';
					$i++;
					
					$output  .= '<div class="acc_item">';
						$output .= '<h4 class="accordion_'.$tab_id.' title_el"><span class="acc_control"></span><span class="acc_heading">'. $tab['title'] .'</span></h4>';
						//$output .= '<div class="arrow"></div>';
						$output .= '<div class="accordion_content'.$tab_id.'">';
							$output .= wpautop(do_shortcode(htmlspecialchars_decode($tab['content'])));
						$output .= '</div>';
					$output .= '</div>';
				}
				
				$output .= '</div>';
				
				$output .="
				<script type='text/javascript'>
$(document).ready(function(){
	
//Set default open/close settings
$('.accordion_content".$tab_id."').hide(); //Hide/close all containers
$('.accordion_".$tab_id.":first').addClass('active_acc').next().show(); 

//On Click
$('.accordion_".$tab_id."').click(function(){
	if( $(this).next().is(':hidden') ) { 
		$('.accordion_".$tab_id."').removeClass('active_acc').next().slideUp(); 
		$(this).toggleClass('active_acc').next().slideDown(); 
	}
	return false; 
});

});
</script>
				";
			}
			
			echo $output;
			
		}
		
		/* AJAX add tab */
		function add_tab() {
			$nonce = $_POST['security'];	
			if (! wp_verify_nonce($nonce, 'aqpb-settings-page-nonce') ) die('-1');
			
			$count = isset($_POST['count']) ? absint($_POST['count']) : false;
			$this->block_id = isset($_POST['block_id']) ? $_POST['block_id'] : 'aq-block-9999';
			
			//default key/value for the tab
			$tab = array(
				'title' => 'Nouvel &eacute;l&eacute;ment ',
				'content' => ''
			);
			
			if($count) {
				$this->tab($tab, $count);
			} else {
				die(-1);
			}
			
			die();
		}
		
		function update($new_instance, $old_instance) {
			$new_instance = aq_recursive_sanitize($new_instance);
			return $new_instance;
		}
	}
}
