<?php
/** A simple text block **/
class AQ_Social_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Réseaux Sociaux',
			'size' => 'span6',
		);
		
		//create the block
		parent::__construct('aq_social_block', $block_options);
	}
	
	function form($instance) {
		
		$social_options = array(
			'cercle' => 'Cercle',
			'carre' => 'Carré',
		);
		
		$defaults = array(
			'text' => '',
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>
		<p class="description">
			<label for="<?php echo $this->get_field_id('title') ?>">
				Titre 
				<?php echo aq_field_input('title', $block_id, $title, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('title_fonts_color') ?>">
				Couleur du titre<br/>
				<?php echo aq_field_color_picker('title_fonts_color', $block_id, $title_fonts_color, $defaults['title_fonts_color']) ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('social_icon') ?>">
				Choisissez la forme des icons.<br/>
				<?php echo aq_field_select('social_icon', $block_id, $social_options, $social_icon, $block_id); ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('facebook') ?>">
				Facebook 
				<?php echo aq_field_input('facebook', $block_id, $facebook, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('tweeter') ?>">
				Tweeter 
				<?php echo aq_field_input('tweeter', $block_id, $tweeter, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('google') ?>">
				Google + 
				<?php echo aq_field_input('google', $block_id, $google, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('skype') ?>">
				Skype 
				<?php echo aq_field_input('skype', $block_id, $skype, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('pinterest') ?>">
				Pinterest
				<?php echo aq_field_input('pinterest', $block_id, $pinterest, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('linkedin') ?>">
				Linkedin
				<?php echo aq_field_input('linkedin', $block_id, $linkedin, $size = 'full') ?>
			</label>
            
            
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
	echo '<h2 class="title" style="color:'.$title_fonts_color.';"><span>'.$title.'</h2>';
	
  switch($social_icon) {
	  
	  case 'cercle':	
	
			// icon cercle
	
	if ($pinterest) {
	echo '
	
		  	<a href="'.$pinterest.'" target="_blank" class="icon_pinterest" title="Pinterest">Pinterest</a>
	    
	';
	}
	if ($tweeter) {
	echo '
	
		  	<a href="'.$tweeter.'" target="_blank" class="icon_tweet" title="Tweeter">Tweeter</a>		
	      
	';
	}
	if ($skype) {
	echo '
		
			<a href="'.$skype.'" class="icon_skype" title="Skype">Skype</a>

	';
	}
	if ($google) {
	echo '
	
		  	<a href="'.$google.'" target="_blank" class="icon_google" title="Google+">Google+</a>
	      	
  
	';
	}
	if ($facebook) {
	echo '
	
		  	
	      	<a href="'.$facebook.'" target="_blank" class="icon_facebook" title="Facebook">Facebook</a>

	';
	}
	if ($linkedin) {
	echo '
	
		
			<a href="'.$linkedin.'" target="_blank" class="icon_linkedin" title="Linkedin">Linkedin</a>

	';
	}
	
	break;
			case 'carre':
				 // icon carre
				 
				 if ($pinterest) {
	echo '
	
		  	<a href="'.$pinterest.'" target="_blank" class="icon_pinterest-2" title="Pinterest">Pinterest</a>
	    
	';
	}
	if ($tweeter) {
	echo '
	
		  	<a href="'.$tweeter.'" target="_blank" class="icon_tweet-2" title="Tweeter">Tweeter</a>		
	      
	';
	}
	if ($skype) {
	echo '
		
			<a href="'.$skype.'" target="_blank" class="icon_skype-2" title="Skype">Skype</a>

	';
	}
	if ($google) {
	echo '
	
		  	<a href="'.$google.'" target="_blank" class="icon_google-2" title="Google+">Google+</a>
	      	
  
	';
	}
	if ($facebook) {
	echo '
	
		  	
	      	<a href="'.$facebook.'" target="_blank" class="icon_facebook-2" title="Facebook">Facebook</a>

	';
	}
	if ($linkedin) {
	echo '
	
		
			<a href="'.$linkedin.'" target="_blank" class="icon_linkedin-2" title="Linkedin">Linkedin</a>

	';
	}
				
				
				
				break;
		}
	
	}
	
	
}