<?php
/* Aqua Tabs Block */
if(!class_exists('AQ_Slide_Block')) {
	class AQ_Slide_Block extends AQ_Block {
	
		function __construct() {
			$block_options = array(
				'name' => 'Galerie défilante',
				'size' => 'span12',
				'resizable' => 0,
			);
			
			//create the widget
			parent::__construct('aq_slide_block', $block_options);
			
			//add ajax functions
			add_action('wp_ajax_aq_block_tab_add_new_slide', array($this, 'add_slide'));
			
		}
		
		function form($instance) {
		
			$defaults = array(
				'tabs' => array(
					1 => array(
						'title' => 'Nouvelle image',
						'image' => 'Nouvelle image',
						
						
					)
				),
				
			);
			
			$instance = wp_parse_args($instance, $defaults);
			extract($instance);
			
			
			?>
            
			<div class="description cf">
            <p class="description">
            <label for="<?php echo $this->get_field_id('tab_title') ?>">
				 Titre
				<?php echo aq_field_input('tab_title', $block_id, $tab_title, $size = 'full') ?>
			</label>
            
            </p>
				<ul id="aq-sortable-list-<?php echo $block_id ?>" class="aq-sortable-list" rel="<?php echo $block_id ?>">
					<?php
					$tabs = is_array($tabs) ? $tabs : $defaults['tabs'];
					$count = 1;
					foreach($tabs as $tab_slide) {	
						$this->tab_slide($tab_slide, $count);
						$count++;
					}
					?>
				</ul>
				<p></p>
				<a href="#" rel="tab" class="aq-sortable-add-new-slide button">Ajouter</a>
				<p></p>
			</div>
            <label for="<?php echo $this->get_field_id('tab_id') ?>">
				 Identifiant
				<?php echo aq_field_input('tab_id', $block_id, $tab_id, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('title_dsc') ?>">
				 Titre de la description
				<?php echo aq_field_input('title_dsc', $block_id, $title_dsc, $size = 'full') ?>
			</label>
			
            <label for="<?php echo $this->get_field_id('text_slide') ?>">
				Contenu
				<?php echo aq_field_textarea('text_slide', $block_id, $text_slide, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('custom_link') ?>">
				Lien personnalisé <em>(Url complète)</em>
				<?php echo aq_field_input('custom_link', $block_id, $custom_link, $size = 'full') ?>
			</label>
            <label for="<?php echo $this->get_field_id('txt_link') ?>">
				 Intitulé du lien
				<?php echo aq_field_input('txt_link', $block_id, $txt_link, $size = 'full') ?>
			</label>
            <label for="<?php echo $this->get_field_id('target_link') ?>">
            
            <?php echo aq_field_checkbox('target_link', $block_id, $target_link, $check);?>
            Ouvrir le lien dans une nouvelle fenêtre/onglet
            </label>
            
			<?php
		}
		
		function tab_slide($tab_slide = array(), $count = 0) {
				
			?>
            
			<li id="<?php echo $this->get_field_id('tabs') ?>-sortable-item-<?php echo $count ?>" class="sortable-item" rel="<?php echo $count ?>">
				
				<div class="sortable-head cf">
					<div class="sortable-title">
                    <?php
					$url = $tab_slide['image'];
					$filename = basename($url);

					?>
						<strong><?php echo $filename; ?></strong>
					</div>
					<div class="sortable-handle">
						<a href="#">Ouvrir / Fermer</a>
					</div>
				</div>
				
				<div class="sortable-body">
						
					<p class="tab-desc description">
                    <input type="text" id="<?php echo $this->get_field_id('tabs') ?>-<?php echo $count ?>-image" class="input-full input-upload"  name="<?php echo $this->get_field_name('tabs') ?>[<?php echo $count ?>][image]" value="<?php echo $tab_slide['image'] ?>">
                    <a href="#" class="aq_upload_button button" rel="<?php echo $media_type; ?>">Envoyer une image</a>
                    </p>
                    <p class="tab-desc description">
                    <img class="upload_images_txt" src="<?php echo $tab_slide['image'] ?>" border="0"/>
                    </p>
					
					<p class="tab-desc description"><a href="#" class="sortable-delete">Supprimer</a></p>
				</div>
				
			</li>
            
            
            
			<?php
		}
		
		function block($instance) {
			extract($instance);
			
			$output = '';
			
			
				
				$output .= '<h2 class="title"><span>'.$tab_title.'</span></h2>';
				
				//$output .= '<div id="tabs_'. rand(1, 100) .'" class="htabs"><div class="'.$tab_id.'">';
				
				$output .= '<!-- FlexSlider -->
				
			<div class="flexslider ten columns">
			<div class="'.$tab_id.'">
		        <ul class="slides">';
					if(!empty($target_link)){
		$target_link_if = 'target="_blank"';}
		else
		{
		$target_link_if = 'target="_self"';
		}
					$i = 1;
					foreach( $tabs as $tab_slide ){
						$tab_selected = $i == 1 ? 'selected' : '';
						$output .= '<li class="pic"><a href="' . $tab_slide['image'] . '" rel="prettyPhoto['.$tab_id.']" title=""><img src="' . $tab_slide['image'] . '" /><span class="img_overlay_zoom"></span></a></li>';
						$i++;
					}
					
					$output .= '</ul>';
					$output .='</div>';
					$output .='</div>';
					
					$output .='<div class="five columns services_description">
					<h2 class="title-video">'.$title_dsc.'</h2>
					'.$text_slide.'
					
					<div class="h20"></div>';
					
					if( $custom_link ) {
		$output .= '<div class="grey-link"><a href="'.$custom_link.'" '.$target_link_if.'>'.strip_tags($txt_link).'</a></div>';
		} else {
			};
					
				$output .='</div>';
				
				
					
					$output .= "
				  				  
				<script type='text/javascript'>
				  $(window).load(function(){
				    $('.".$tab_id."').flexslider({
				      animation: 'slide',
				      controlNav: false,
				      start: function(slider){
				        $('body').removeClass('loading');
				      }
				    });
				  });
				</script>";
				
			?>
            <script type="text/javascript" charset="utf-8">
					$(document).ready(function(){
						$(".pic a[rel^='prettyPhoto']").prettyPhoto({
							animation_speed:'normal',
							overlay_gallery: false,
							social_tools: false
						});
					});
</script>
            <?php
			
			
			echo $output;
			
			
		}
		
		/* AJAX add tab */
		function add_slide() {
			$nonce = $_POST['security'];	
			if (! wp_verify_nonce($nonce, 'aqpb-settings-page-nonce') ) die('-1');
			
			$count = isset($_POST['count']) ? absint($_POST['count']) : false;
			$this->block_id = isset($_POST['block_id']) ? $_POST['block_id'] : 'aq-block-9999';
			
			//default key/value for the tab
			$tab_slide = array(
				'title' => 'Nouvelle Image',
				'image' => 'Nouvelle Image',
				
			);
			
			if($count) {
				$this->tab_slide($tab_slide, $count);
			} else {
				die(-1);
			}
			
			die();
		}
		
		function update($new_instance, $old_instance) {
			$new_instance = aq_recursive_sanitize($new_instance);
			return $new_instance;
		}
	}
}
