<?php
/** A simple text block **/
class AQ_post_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Carousel',
			'size' => 'span12',
			'resizable' => 0,
		);
		
		//create the block
		parent::__construct('aq_post_block', $block_options);
	}
	
	function form($instance) {
		
		$colonnes_options = array(
			'2' => '2 colonnes',
			'3' => '3 colonnes',
			'4' => '4 colonnes',
			
			
		);
		
		$defaults = array(
			'excerpth1' => '30',
			'number_post' => '4',
			'img_width' => '180',
			'img_height' => '180',
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		$block_color = isset($block_color) ? $block_color : '#353535';
		$title_fonts_color = isset($title_fonts_color) ? $title_fonts_color : '#ffffff';
		?>
        <p class="description">
			<label for="<?php echo $this->get_field_id('title') ?>">
				Titre du bloc des articles
				<?php echo aq_field_input('title', $block_id, $title, $size = 'full') ?>
			</label>
		</p>
        <div class="description">
	            
            <label for="<?php echo $this->get_field_id('title_fonts_color') ?>">
				Couleur du titre<br/>
				<?php echo aq_field_color_picker('title_fonts_color', $block_id, $title_fonts_color, $defaults['title_fonts_color']) ?>
			</label>
			
		</div>
		<p class="description">
        <h4>Paramètre des articles</h4>
			<label for="<?php echo $this->get_field_id('number_post') ?>">
				<div style="width:200px; float:left;">Nombre d'articles</div>
				<?php echo aq_field_input('number_post', $block_id, $number_post, $size = 'min') ?>
			</label>
            <br />
			<label for="<?php echo $this->get_field_id('excerpth1') ?>">
				<div style="width:200px; float:left;">Longueur des extraits</div>
				<?php echo aq_field_input('excerpth1', $block_id, $excerpth1, $size = 'min') ?>
			</label>
            <br />
            <label for="<?php echo $this->get_field_id('img_width') ?>">
				Largeur des images
				<?php echo aq_field_input('img_width', $block_id, $img_width, $size = 'min') ?>
			</label>
            <br />
            <label for="<?php echo $this->get_field_id('img_height') ?>">
				Hauteur des images
				<?php echo aq_field_input('img_height', $block_id, $img_height, $size = 'min') ?>
			</label>
            <br />
            <label for="<?php echo $this->get_field_id('id_post') ?>">
				<div style="width:200px; float:left;">Identifiant</div>
				<?php echo aq_field_input('id_post', $block_id, $id_post, $size = 'min') ?>
			</label>
            <br />
			<label for="<?php echo $this->get_field_id('post_colonnes') ?>">
				Choisissez le nombre de colonnes.<br/>
				<div style="width:250px;"><?php echo aq_field_select('post_colonnes', $block_id, $colonnes_options, $post_colonnes, $block_id); ?></div>
			</label>
			<br />
            
        <label><?php _e( 'Categorie' ); ?>:</label>
		<div style="width:250px;"><?php wp_dropdown_categories( array( 'show_option_all' => __('ALL'),'hide_empty'  => 0,'name' => $this->get_field_name("cat_posts"), 'selected' => $instance["cat_posts"] ) ); ?></div>
        	</p>
            <div class="clear-block"></div>
         <p class="description">
        <div style="width:200px; float:left;"><label><?php _e( 'Afficher le titre des articles' ); ?>:</label></div>
		<?php echo aq_field_checkbox ('title_post_display', $block_id, $title_post_display,$check) ?>
        	</p>
           
          <p class="description">
        <label><?php _e( 'Afficher le nombre de commentaire' ); ?>:</label>
		<?php echo aq_field_checkbox ('comment_post', $block_id, $comment_post,$check) ?>
        	</p>
            
            <p class="description">
            <h4>Paramètre du carousel</h4>
			<label for="<?php echo $this->get_field_id('carousel_speed') ?>">
				<div style="width:200px; float:left;">Vitesse de défilement en milliseconde seconde</div>
				<?php echo aq_field_input('carousel_speed', $block_id, $carousel_speed, $size = 'min') ?>
			</label>
            
            
		</p>
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
echo '<div class="row">';		
echo '<h2 class="sixteen columns title" style="color:'.$title_fonts_color.';"><span>'.$title.'</h2>';
echo '<div class="clear"></div>';
echo '<div class="row">
				<div class="section_featured_services">
					<div class="carousel_arrows_bgr"></div>';
					
					// WP 3.0 PAGED BUG FIX
			if ( get_query_var('paged') )
				$paged = get_query_var('paged');
			elseif ( get_query_var('page') )
				$paged = get_query_var('page');
			else
				$paged = 1;
			
			$args = array( 'post_type' => 'post',
						   'posts_per_page' => $number_post,
						   'cat' => $cat_posts,
						   'paged' => $paged ); 
			query_posts($args);		
					
					
	

echo '<ul id="featured_services_carousel" class="featured_services_'.$id_post.'">';
                    
                    if (have_posts()) : $count = 0;
            
            		while (have_posts()) : the_post(); $count++; global $post; ?>
                    
                     <?php               
                                 switch($post_colonnes) {
			case '2':
				echo '<li class="six columns';
				break;
			
			case '3':
				echo '<li style="margin-left:5px;" class="four columns';
				break;
			case '4':
				echo '<li  style="margin-left:5px;" class="three columns';
				echo '';
				break;
			
		}
                ?> <?php echo $count; ?> <?php if ($count % 4 == 0) { echo ''; } ?>">
                        
           
							<div class="pic">
								
                                <?php 
if (has_post_thumbnail()) { ?>
<?php $thumb = get_post_thumbnail_id(); $img_url = wp_get_attachment_url( $thumb,'full' ); $image = sp_resize( $img_url, 246, 150, true ); ?>
<a href=" <?php the_permalink() ?>" title="<?php the_title(); ?>"><img src="<?php echo $image ?>" border="0"/><div class="img_overlay"></div></a>  
<?php  } else { } ?>
                                
							</div>
                            <?php if($title_post_display) { ?>
							 <h4><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h4>
                            <?php } else { }?>
							<p><?php echo excerpt($excerpth1);?></p>
						</li>
						 <?php if ($count % 4 == 0) { echo ''; } ?>
            
            
            <?php endwhile; ?> 
            <?php endif; ?>
            <?php wp_reset_query();?>		
					</ul>
				</div>
			</div>
            
            <script type="text/javascript">
			
				$(document).ready(function() {
					
					
					
					
						$('.featured_services_<?php echo $id_post; ?>').jcarousel({
						   	scroll: ($(window).width() > 767 ? <?php echo $post_colonnes;?> : 1),
						   	easing: 'easeInOutExpo',
							auto: <?php echo $post_colonnes;?>,
							wrap: 'last',
						   	animation: <?php echo $carousel_speed;?>
							
						});
				});
				
				// Reload carousels on window resize to scroll only 1 item if viewport is small
			    $(window).resize(function() {
			    	 var el = $(".featured_services_<?php echo $id_post; ?>"), carousel = el.data('jcarousel'), win_width = $(window).width();
			    	   var visibleItems = (win_width > 767 ? <?php echo $post_colonnes;?> : 1);
			    	   carousel.options.visible = visibleItems;
			    	   carousel.options.scroll = visibleItems;
			    	   carousel.reload();
			    });
			</script>
            </div>
			<!-- Section::END -->
		

<?php
	}
	
}
