<?php
/** A simple text block **/
class AQ_Portfolio_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Portfolio',
			'size' => 'span12',
			'resizable' => 0,
		);
		
		//create the block
		parent::__construct('aq_portfolio_Block', $block_options);
	}
	
	function form($instance) {
		
		$defaults = array(
			'excerpth1' => '30',
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		?>
        <p class="description">
       
			<label for="<?php echo $this->get_field_id('title') ?>">
				Titre du Portfolio
				<?php echo aq_field_input('title', $block_id, $title, $size = 'full') ?>
			</label>
           
		</p>
        
        <p class="description">
       
			<label for="<?php echo $this->get_field_id('folio_id') ?>">
				Idendifiant
				<?php echo aq_field_input('folio_id', $block_id, $folio_id, $size = 'full') ?>
			</label>
           
		</p>

            <p class="description">
        <div style="width:300px; float:left;"><label><?php _e( 'Ajouter les Identifiant des catégories a afficher' ); ?>:</label></div>
		<?php echo aq_field_input('cat_ID', $block_id, $cat_ID, $size = 'small') ?>
        <br />
        <h4>Catégories disponible avec leur Identifiant</h4>
         <?php
			$args=array(
			  'orderby' => 'name',
			  'order' => 'ASC',
			  'hide_empty'=> 0
			  );
			$categories=get_categories($args);
			  foreach($categories as $category) { 
				echo '<p><strong>' . $category->name.'</strong> Identifiant : <strong>'. $category->term_id . '</strong></p> ';
			  } 
		?>
        	</p>
            <br/><br/>
            <p class="description">
        <div style="width:300px; float:left;"><label><?php _e( "Nombre d'article a afficher" ); ?>:</label></div>
		<?php echo aq_field_input('nb_post', $block_id, $nb_post, $size = 'small') ?>

        	</p>
           <p class="description">
             <label for="<?php echo $this->get_field_id('title_folio') ?>">
            
            <?php echo aq_field_checkbox('title_folio', $block_id, $title_folio, $check);?>
            Afficher le titre sur les vignettes ?
            </label>
             </p>
          
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
		
	

?>  

<div class="row">

<!-- Portfolio -->
		<script type="text/javascript">
			$(document).ready(function(){
		
		        var $filterType = $('#portfolio_filter div.current').attr('data-value');
		        var $holder = $('#portfolio_items');
		        var $data = $holder.clone();
		        var $preferences = {
		            duration: 600,
		            easing: 'easeInOutQuad'
		        };
				
				$('#portfolio_filter > div').click(function(e){

			          $('#portfolio_filter > div').removeClass('current');
			          var $filterType = $(this).attr('data-value');

			          $(this).addClass('current');
		            
			          if($filterType == 'all'){
			          		var $filteredData = $data.find('li');
			          }
			          else{
			          		var $filteredData = $data.find('li[data-type~=' + $filterType + ']');
			          }
			            
			          $holder.quicksand($filteredData, $preferences);

			     });
			 
			});
		</script>     
<div class="row">
		
                
                
     <div class="portfolio sixteen columns">
     <?php echo '<div class="page_heading"><h1 style="color:'.$title_fonts_color.';">'.$title.'</h1></div>';?>
				<div id="portfolio_filter" class="portfolio_filter clearfix">
                <div data-value="all" class="current">Tout</div>            
	<?php $categories = get_categories('orderby=name&depth=1&include='.$cat_ID.'&title_li=&use_desc_for_title=1'); foreach ($categories as $cat) { ?>
	<div data-value="<?php echo $cat->slug; ?>"><?= $cat->cat_name; ?></div>
	<?php } ?>
	</div>

	
	 
				<ul id="portfolio_items" class="clearfix">
                
                <?php
					$the_query = new WP_Query('cat='.$cat_ID.'&showposts='.$nb_post.'');
					
					while ($the_query->have_posts()) : 
					$the_query->the_post();
					$categories = get_the_category(); 
					$cat_name = $categories[0]->slug;
						
					
					?>
                
				  <li data-id="id-<?php the_ID(); ?>" class="portfolio_item" data-type="<?php echo $cat_name; ?>">
				  	<a href="<?php the_permalink(); ?>" rel="prettyPhoto" title="<?php the_title(); ?>">
				  		<span class="pic"> 
                        <?php if ($title_folio) { ?>
                        <h5><?php the_title(); ?></h5>
                        <?php } else {} ?>
						<?php 
												if (has_post_thumbnail()) { ?>
												<?php $thumb = get_post_thumbnail_id(); $img_url = wp_get_attachment_url( $thumb,'full' ); $image = sp_resize( $img_url, 300, 200, true ); ?>
												<img class="img-home" src="<?php echo $image ?>" border="0"/>  
												<?php  } else { } ?><div class="img_overlay"></div></span>
				  		
                        
				  	</a>
				  </li>
				 <?php  

					endwhile;
					
					?>
				</ul>
	
			</div>
		</div>
        
		<!-- Portfolio::END -->
</div>
<?php
	}
	
}