<?php
/** "Clear" block 
 * 
 * Clear the floats vertically
 * Optional to use horizontal lines/images
**/
class AQ_Clear_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Clear',
			'size' => 'span12',
			'resizable' => 0,
		);
		
		//create the block
		parent::__construct('aq_clear_block', $block_options);
	}
	
	function form($instance) {
		
		$defaults = array(
			'horizontal_line' => 'none',
			'line_color' => '#353535',
			'pattern' => '1',
			'height' => ''
		);
		
		$line_options = array(
			'none' => 'Aucune',
			'single' => 'Simple',
			'double' => 'Pointillé',
			'image' => 'Use Image',
		);
		
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		
		$line_color = isset($line_color) ? $line_color : '#353535';
		
		?>
		<p class="description note">
			<?php _e('Utiliser ce bloc  pour séparés plusieurs blocs  verticalement.', 'framework') ?>
		</p>
		<p class="description fourth">
			<label for="<?php echo $this->get_field_id('line_color') ?>">
				Choisissez une ligne horizontale.<br/>
				<?php echo aq_field_select('horizontal_line', $block_id, $line_options, $horizontal_line, $block_id); ?>
			</label>
		</p>
		<div class="description fourth">
			<label for="<?php echo $this->get_field_id('height') ?>">
				Marge Haut et Bas<br/>
				<?php echo aq_field_input('height', $block_id, $height, 'min', 'number') ?> px
			</label>
		</div>
		<div class="description half last">
			<label for="<?php echo $this->get_field_id('line_color') ?>">
				Choisissez une couleur de ligne<br/>
				<?php echo aq_field_color_picker('line_color', $block_id, $line_color, $defaults['line_color']) ?>
			</label>
			
		</div>
		<?php
		
	}
	
	function block($instance) {
		extract($instance);
		
		switch($horizontal_line) {
			case 'none':
				break;
			case 'single':
				echo '<div class="aq-block-clear aq-block-hr-single" style="margin-bottom:'.$height.'px; margin-top:'.$height.'px; width:100%; height:1px;border-top: solid 1px '.$line_color.';"/></div>';
				break;
			case 'double':
				echo '<div class="aq-block-clear aq-block-hr-double" style="margin-bottom:'.$height.'px; margin-top:'.$height.'px;border-top: dotted 1px '.$line_color.';"/></div>';
				echo '';
				break;
			case 'image':
				echo '<hr class="aq-block-clear aq-block-hr-image cf"/>';
				break;
		}
		
		if($height) {
			echo '<div style="margin-bottom:'.$height.'px; margin-top:'.$height.'px;"></div>';
		}
		
	}
	
}